<?php
/**
* @version      $Id: replacecardsymbols.php 10110 2008-03-06 12:51:09Z instance $
* @package      Joomla
* @copyright    Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license      GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

$mainframe->registerEvent('onPrepareContent', 'plgReplaceCardSymbols');

/**
 * Plugin that replaces !S, !H, !D, !C with their respective HTML codes for card symbols.
 *
 * @param object|string An object with a "text" property to be replaced.
 * @param array Additional parameters.
 * @param int Optional page number. Unused. Defaults to zero.
 * @return boolean True on success.
 */
function plgReplaceCardSymbols(&$row, &$params, $page=0)
{
    if (is_object($row)) {
        return plgSymbolReplace($row->text, $params);
    }
    return plgSymbolReplace($row, $params);
}

/**
 * function that replaces !S, !H, !D, !C with their respective HTML codes for card symbols.
 *
 * @param string The string to be replaced.
 * @param array Additional parameters. 
 * @return boolean True on success.
 */
function plgSymbolReplace(&$text, &$params)
{
    $plugin = & JPluginHelper::getPlugin('content', 'replacecardsymbols');

		$text = JString::str_ireplace('!H', '&hearts;', $text);
		$text = JString::str_ireplace('!S', '&spades;', $text);
		$text = JString::str_ireplace('!D', '&diams;', $text);
		$text = JString::str_ireplace('!C', '&clubs;', $text);
		
		$text = JString::str_ireplace('&hearts;', '<span style="color: #FF0000">&hearts;</span>', $text);
		$text = JString::str_ireplace('&spades;', '<span style="color: #111111">&spades;</span>', $text);
		$text = JString::str_ireplace('&diams;',  '<span style="color: #FF0000">&diams;</span>', $text);
		$text = JString::str_ireplace('&clubs;',  '<span style="color: #111111">&clubs;</span>', $text);
		
		return true;
}
