<?php
/**
 * Definition file
 *
 * Based on jombackup by Vince Wool   
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package LazyBackup
 * @author Granholmcms
 * @link http://www.granholmcms.com
 * @link http://www.csvimproved.com
 * @copyright Copyright (C) 2008 granholmcms.com
 * @version $Id: lazybackup.php 194 2008-04-08 07:52:56Z   $
 */
defined('_JEXEC') or die('Restricted access');

/* Import library dependencies */
jimport('joomla.event.plugin');

class plgSystemlazybackup extends JPlugin {
	
	function onAfterInitialise() {
		$plugin =& JPluginHelper::getPlugin( 'system', 'lazybackup' );
		$pluginParams = new JParameter( $plugin->params );
		$db =& JFactory::getDBO();
		$config =& JFactory::getConfig();
		
		$lb_abspath    = JPATH_SITE;
		$lb_host       = $config->getValue('config.host');
		$lb_user       = $config->getValue('config.user');
		$lb_password   = $config->getValue('config.password');
		$lb_db         = $config->getValue('config.db');;
		$lb_mailfrom   = $config->getValue('config.mailfrom');
		$lb_fromname   = $config->getValue('config.fromname');;
		$lb_livesite   = JURI::root();
		$testing       = false;
		$mediaPath=$lb_abspath.'/media';
		$checkfileName='lazybackup_checkfile_';
		$today = date("Y-m-d");
		$dateCheckFile=$checkfileName.$today;
		$okToContinue=true;
		 
		/**
		 * Check if we need to run again
		 */
		jimport( 'joomla.filesystem.folder' );
		$files = JFolder::files($mediaPath, 'lazybackup_checkfile(.*)');
		$lastruntime = 0;
		foreach ($files as $key => $filename) {
			if (stristr($filename, 'lazybackup_checkfile')) {
				$timestamp = strtotime(substr($filename, -10, 10));
				if ($timestamp > $lastruntime) {
					$lastruntime = strtotime(substr($filename, -10, 10));
				}
			}
		}
		$xdays = $pluginParams->def( 'xdays', 1 );
		$triggerdate = time() - ($xdays * 86400);
		if ($lastruntime < $triggerdate) {
			
			/** 
			 * You can manually set the production flag here if you don't want the 
			 * "testing" option to kick in at any point. Effectively it means that 
			 * the mambot query will not be run until $okToContinue is true, which
			 * only occurs if today's checkFile doesn't exist.
			 * If you DO manually set this flag, then of course none of the testing 
			 * data will be echoed to your browser
			 */
			$production    = false;
			
			/**
			 * This query has been deliberately placed in this part of the code to 
			 * allow the user to perform tests to ensure that the script is working, 
			 * however it means that this script performs 1 sql query every time 
			 * Joomla runs, unless $production is set to true.
			 */
		   /* load mambot params info */
		   if (!$production) {
			  $testing   = $pluginParams->def( 'testing', 0 );
		   }
		   /* Finish bot parameter loading */
		   
		   if ($testing) {
			  $yesterday=date("Y-m-d" ,$lastruntime );
			  $yesterdaysCheckfile=$checkfileName.$yesterday;
			  if (is_file($mediaPath.'/'.$dateCheckFile) && @is_writable($mediaPath.'/'.$dateCheckFile) ) {
				 unlink($mediaPath.'/'.$dateCheckFile);
			  }
		   }
		   /* a couple of simple checks to see if we need to actually do anything */
		   if (is_writable($mediaPath) ) {
			  /* The backup has already been done, no need to continue */
			  if (is_file($mediaPath.'/'.$dateCheckFile) ) 
				 $okToContinue=false;
			  else
				 {
				 if (!$testing) {
					/* Oops, we can't create the date check file, no point in continuing otherwise this plugin will run EVERY time a link is clicked in Joomla. Not good.*/
					if (!touch($mediaPath.'/'.$dateCheckFile))
					   $okToContinue=false;
					}
				 }
			  }
		   else
			  $okToContinue=false;
		   if ($testing) {
			  if ($okToContinue)
				 echo "Backing up and emailing system mysqldata<br />";
			  else
				 echo "Not backing up system data<br />";
		   }
		   if ($okToContinue) {
			  /* No need to do the require beforehand if not ok to continue, so we'll do it here to save an eeny weeny amount of time */
			  require_once($lb_abspath.'/plugins/system/lazybackup/mysql_db_backup.class.php');
			  /* Alternative location for Bot query  */
			  if ($production) $testing   = $pluginParams->def( 'testing', 0 );
			  $deletefile      = $pluginParams->def( 'deletefile', false );
			  $compress      = $pluginParams->def( 'compress', 0 );
			  $backuppath      = $pluginParams->def( 'backuppath', 0 );
		
			  /* Ok, let's crack on. First we want to get rid of the previous lazybackup_checkfile, no need to have that lying around now */
			  $yesterday=date("Y-m-d" ,$lastruntime );
			  $yesterdaysCheckfile=$checkfileName.$yesterday;
			  if (is_file($mediaPath.'/'.$yesterdaysCheckfile) && @is_writable($mediaPath.'/'.$yesterdaysCheckfile) ) {
				  unlink($mediaPath.'/'.$yesterdaysCheckfile);
			  }
			  /* Now we need to create the backup */
			  $backup_obj = new Lazybackup_MySQL_DB_Backup();
			  $result=$this->lazybackupBackup($backup_obj,$lb_host,$lb_user,$lb_password,$lb_db,$pluginParams,$mediaPath,$lb_fromname,$compress,$backuppath);
			  $backupFile=$backup_obj->lazybackup_file_name;
			  /* and email it to wherever */
			  $EmailResult=$this->lazybackupEmail($pluginParams,$lb_mailfrom,$lb_fromname,$backupFile,$result['output'],$lb_livesite);
			  if ($deletefile=="1" && !empty($backupFile) )
				 {
				 if ($testing)
					echo "Deleting backup file $backupFile";
				 	unlink($backupFile);
				 }
			  else if ($testing)
				 echo "Not deleting backup file $backup_obj->lazybackup_file_name";
			  /* Job done */
			  }
			  return true;
		}
		else if ($testing) {
			echo 'Nothing to do';
		}
	}
   
	function lazybackupEmail($pluginParams,$lb_mailfrom,$lb_fromname,$Attachment,$Body,$lb_livesite) {
		$mail =& JFactory::getMailer();
		$ToEmail       = $pluginParams->def( 'recipient', '' );
		$Subject       = $pluginParams->def( 'subject', 'Mysql backup' );
		$FromName       = $pluginParams->def( 'fromname', $lb_fromname );
		if (empty($ToEmail) ) $ToEmail=$lb_mailfrom;
		
		$mail->addAttachment($Attachment);
		$mail->addRecipient($ToEmail);
		$mail->setSubject($Subject.' '.$lb_livesite);
		$mail->setBody($Body);
		$mail->Send();
	}
	
	function lazybackupBackup(&$backup_obj,$lb_host,$lb_user,$lb_password,$lb_db,$pluginParams,$mediaPath,$lb_fromname,$compress,$backuppath)
	   {
	   $Body             = $pluginParams->def( 'body', 'Mysql backup from '.$lb_fromname );
	   $drop_tables       = $pluginParams->def( 'drop_tables', 1 );
	   $create_tables       = $pluginParams->def( 'create_tables', 1 );
	   $struct_only       = $pluginParams->def( 'struct_only', 1 );
	   $locks             = $pluginParams->def( 'locks', 1 );
	   $comments          = $pluginParams->def( 'comments', 1 );
	   if (!empty($backuppath) && is_dir($backuppath) && @is_writable($backuppath)  )
		  $backup_dir       = $backuppath;
	   else
		  $backup_dir       = $mediaPath;
	
	   /* START - REQUIRED SETUP VARIABLES */
	   $backup_obj->server    = $lb_host;
	   $backup_obj->port       = 3306;
	   $backup_obj->username    = $lb_user;
	   $backup_obj->password    = $lb_password;
	   $backup_obj->database    = $lb_db;
	   /* Tables you wish to backup. All tables in the database will be backed up if this array is null. */
	   $backup_obj->tables = array();
	   /* END - REQUIRED SETUP VARIABLES */
	   
	   /* START - OPTIONAL PREFERENCE VARIABLES */
	   /* Add DROP TABLE IF EXISTS queries before CREATE TABLE in backup file. */
	   $backup_obj->drop_tables = $drop_tables;
	   /* No table structure will be backed up if false */
	   $backup_obj->create_tables = $create_tables;
	   /* Only structure of the tables will be backed up if true. */
	   $backup_obj->struct_only = $struct_only;
	   /* Add LOCK TABLES before data backup and UNLOCK TABLES after */
	   $backup_obj->locks = $locks;
	   /* Include comments in backup file if true. */
	   $backup_obj->comments = $comments;
	   /* Directory on the server where the backup file will be placed. Used only if task parameter equals MSX_SAVE. */
	   $backup_obj->backup_dir = $backup_dir.'/';
	   /* Default file name format. */
	   $backup_obj->fname_format = 'd_m_Y';
	   /* Values you want to be intrerpreted as NULL */
	   $backup_obj->null_values = array( );
	
	   $savetask = MSX_SAVE;
	   /* Optional name of backup file if using 'MSX_APPEND', 'MSX_SAVE' or 'MSX_DOWNLOAD'. If nothing is passed, the default file name format will be used. */
	   $filename = '';
	   /* END - REQUIRED EXECUTE VARIABLES */
	   $result_bk = $backup_obj->Execute($savetask, $filename, $compress);
	   if (!$result_bk)
		  {
		  $output = $backup_obj->error;
		  }
	   else
		  {
		  $output = $Body.': ' . strftime('%A  %d  %B  %Y    - %T  ') . ' ';
		  }
	   return array('result'=>$result_bk,'output'=>$output);
	   }
}
?>