<?php
////////////////////////////////////////////////////////////////////
// FILE:         rereplacer.php
//------------------------------------------------------------------
// PACKAGE:      rereplacer
// NAME:         ReReplacer!
// DESCRIPTION:  ReReplacer! ...search and replace for Joomla!
// VERSION:      1.1.0
// CREATED:      March 2008
// MODIFIED:     May 2008
//------------------------------------------------------------------
// AUTHOR:       NoNumber! (Peter van Westen)
// E-MAIL:       peter@nonumber.nl
// WEBSITE:      http://www.nonumber.nl
//------------------------------------------------------------------
// COPYRIGHT:    (C) 2008-2010 - NoNumber! - All Rights Reserved
// LICENSE:      http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
////////////////////////////////////////////////////////////////////

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

// Import library dependencies
jimport('joomla.event.plugin');

/**
* Plugin that replaces stuff
*/
class plgSystemReReplacer extends JPlugin {
	/**
	* Constructor
	*
	* For php4 compatability we must not use the __constructor as a constructor for
	* plugins because func_get_args ( void ) returns a copy of all passed arguments
	* NOT references.  This causes problems with cross-referencing necessary for the
	* observer design pattern.
	*/
	function plgSystemReReplacer( &$subject ) {
		parent::__construct( $subject );
		
		// load plugin parameters
		$this->_plugin = JPluginHelper::getPlugin( 'system', 'rereplacer' );
		$this->_params = new JParameter( $this->_plugin->params );

		$RR_params = array();
		$RR_params['off']							= plgSystemReReplacer::getOffState('rr_off');
		$RR_params['protector_string']				= 'REREPLACER_STRING_PROTECTION';
		
		$RR_params['article_search_list']			= $this->_params->get('search_list');
		$RR_params['article_replace_list']			= $this->_params->get('replace_list');
		$RR_params['article_remove_list']			= $this->_params->get('remove_list');
		$RR_params['article_enable_secscats']		= $this->_params->get('enable_secscats', 1);
		$RR_params['article_enable_tags']			= $this->_params->get('enable_tags', 0);
		$RR_params['article_enable_tagparams']		= $this->_params->get('enable_tagparams', 'title, alt');
		$RR_params['article_case_insensitive']		= $this->_params->get('case_insensitive', 0);

		$RR_params['everywhere_search_list']		= $this->_params->get('everywhere_search_list');
		$RR_params['everywhere_replace_list']		= $this->_params->get('everywhere_replace_list');
		$RR_params['everywhere_remove_list']		= $this->_params->get('everywhere_remove_list');
		$RR_params['everywhere_enable_tags']		= $this->_params->get('everywhere_enable_tags', 0);
		$RR_params['everywhere_enable_tags']		= $this->_params->get('everywhere_enable_tags', 0);
		$RR_params['everywhere_enable_tagparams']	= $this->_params->get('everywhere_enable_tagparams', 'title, alt');
		$RR_params['everywhere_case_insensitive']	= $this->_params->get('everywhere_case_insensitive', 0);

		$RR_params['nr_of_regex']					= 12;
		$RR_params['regex']							= array();
		for($i = 1; $i <= $RR_params['nr_of_regex']; $i++ ) {
			$RR_params['regex'][$i]							= array();
			$RR_params['regex'][$i]['off']					= plgSystemReReplacer::getOffState('rr_off_'.$i);
			$RR_params['regex'][$i]['search']				= $this->_params->get('regex_search_'.$i);
			$RR_params['regex'][$i]['replace']				= $this->_params->get('regex_replace_'.$i);
			$RR_params['regex'][$i]['enable']				= $this->_params->get('regex_enable_'.$i, 0);
			$RR_params['regex'][$i]['enable_tags']			= $this->_params->get('regex_enable_tags_'.$i, 0);
			$RR_params['regex'][$i]['enable_tagparams']		= $this->_params->get('regex_enable_tagparams_'.$i, 'title, alt');
			$RR_params['regex'][$i]['case_insensitive']		= $this->_params->get('regex_case_insensitive_'.$i, 0);
		}

		$this->RR_params = $RR_params;
	}
	
////////////////////////////////////////////////////////////////////
// ARTICLES
////////////////////////////////////////////////////////////////////
	function onPrepareContent( &$article ) {
		global $mainframe;
		
		if( $mainframe->isAdmin() ) return;
		if ( $this->RR_params['off'] ) return;	

		$search_list	= $this->RR_params['article_search_list'];
		$replace_list	= $this->RR_params['article_replace_list'];
		$remove_list	= $this->RR_params['article_remove_list'];
		
		// Replace in Articles
		if( $search_list ) {
			$search_list_array	= explode(',',$search_list);
			$replace_list_array	= explode(',',$replace_list);
			$replace_list_array	= (count($replace_list_array) == 1)?$replace_list:$replace_list_array;
			if ( isset($article->title) || $this->RR_params['article_enable_secscats'] ) {
				// in articles and in sections / categories if enabled
				$article->text		= $this->replacer($search_list_array, $replace_list_array, $article->text, $this->RR_params['article_case_insensitive'], $this->RR_params['article_enable_tags'], $this->RR_params['article_enable_tagparams']);
			}
			if ( isset($article->title) ) {
				// in articles
				$article->title = $this->replacer($search_list_array, $replace_list_array, $article->title, $this->RR_params['article_case_insensitive'], $this->RR_params['article_enable_tags'], $this->RR_params['article_enable_tagparams']);
			}
		}

		// Remove in Articles
		if( $remove_list ) {
			$remove_list_array	= explode(',',$remove_list);
			if ( isset($article->title) || $this->RR_params['article_enable_secscats'] ) {
				// in articles and in sections / categories if enabled
				$article->text = $this->replacerNormal($remove_list_array, '', $article->text, $this->RR_params['article_case_insensitive'], $this->RR_params['article_enable_tags'], $this->RR_params['article_enable_tagparams']);
			}
			if ( isset($article->title) ) {
				// in articles
				$article->title = $this->replacerNormal($remove_list_array, '', $article->title, $this->RR_params['article_case_insensitive'], $this->RR_params['article_enable_tags'], $this->RR_params['article_enable_tagparams']);
			}
		}
		
		// Regular Expressions in Articles
		for($i = 1; $i <= $this->RR_params['nr_of_regex']; $i++ ) {
			if ( !$this->RR_params['regex'][$i]['off'] && ( $this->RR_params['regex'][$i]['enable'] == 'articles' || $this->RR_params['regex'][$i]['enable'] == 'secscats' ) && $this->RR_params['regex'][$i]['search'] ) {
				if ( isset($article->title) || $this->RR_params['regex'][$i]['enable'] == 'secscats' ) {	
					// in articles and in sections / categories if enabled
					while( preg_match('#'.$this->RR_params['regex'][$i]['search'].'#s', $article->text) ) {
						$article->text = $this->replacerRegEx($this->RR_params['regex'][$i]['search'], $this->RR_params['regex'][$i]['replace'], $article->text, $this->RR_params['regex'][$i]['case_insensitive'], $this->RR_params['regex'][$i]['enable_tags'], $this->RR_params['regex'][$i]['enable_tagparams']);
					}
				}
				if ( isset($article->title) ) {
					// in articles
					while( preg_match('#'.$this->RR_params['regex'][$i]['search'].'#s', $article->title) ) {
						$article->title = $this->replacerRegEx($this->RR_params['regex'][$i]['search'], $this->RR_params['regex'][$i]['replace'], $article->title, $this->RR_params['regex'][$i]['case_insensitive'], $this->RR_params['regex'][$i]['enable_tags'], $this->RR_params['regex'][$i]['enable_tagparams']);
					}
				}
			}
		}
		
		return true;
		
	}

////////////////////////////////////////////////////////////////////
// EVERYWHERE
////////////////////////////////////////////////////////////////////	
	function onAfterRender() {
		global $mainframe;
		
		if( $mainframe->isAdmin() ) return;
		if ( $this->RR_params['off'] ) return;	
	
		$body = JResponse::getBody();

		$search_list	= $this->RR_params['everywhere_search_list'];
		$replace_list	= $this->RR_params['everywhere_replace_list'];
		$remove_list	= $this->RR_params['everywhere_remove_list'];
		
		// Replace everywhere
		if( $search_list ) {
			$search_list_array	= explode(',',$search_list);
			$replace_list_array	= explode(',',$replace_list);
			$replace_list_array	= (count($replace_list_array) == 1)?$replace_list:$replace_list_array;

			$body = $this->replacerNormal($search_list_array, $replace_list_array, $body, $this->RR_params['everywhere_case_insensitive'], $this->RR_params['everywhere_enable_tags'], $this->RR_params['everywhere_enable_tagparams']);
		}

		// Remove everywhere
		if( $remove_list ) {
			$remove_list_array	= explode(',',$remove_list);
			$body = $this->replacerNormal($remove_list_array, '', $body, $this->RR_params['everywhere_case_insensitive'], $this->RR_params['everywhere_enable_tags'], $this->RR_params['everywhere_enable_tagparams']);
		}
		
		// Regular Expressions everywhere
		for($i = 1; $i <= $this->RR_params['nr_of_regex']; $i++ ) {
			if ( !$this->RR_params['regex'][$i]['off'] && $this->RR_params['regex'][$i]['enable'] == 'everywhere' && $this->RR_params['regex'][$i]['search'] ) {
				while( preg_match('#'.$this->RR_params['regex'][$i]['search'].'#s', $body) ) {
					$body = $this->replacerRegEx($this->RR_params['regex'][$i]['search'], $this->RR_params['regex'][$i]['replace'], $body, $this->RR_params['regex'][$i]['case_insensitive'], $this->RR_params['regex'][$i]['enable_tags'], $this->RR_params['regex'][$i]['enable_tagparams']);
				}
			}
		}

		$body = $this->replacerClean( $body );
		
		JResponse::setBody($body);
		
		return true;
	}

////////////////////////////////////////////////////////////////////
// FUNCTIONS
////////////////////////////////////////////////////////////////////
	function replacerNormal($search, $replace, $string, $caseInsensitive = 0, $enableTags = 0, $enableTagParams = '' ) {
		return $this->replacer($search, $replace, $string, 0, $caseInsensitive, $enableTags, $enableTagParams );
	}
	function replacerRegEx($search, $replace, $string, $caseInsensitive = 0, $enableTags = 0, $enableTagParams = '' ) {
		return $this->replacer($search, $replace, $string, 1, $caseInsensitive, $enableTags, $enableTagParams );
	}
	
	function replacer($search, $replace, $string, $isRegex = 0, $caseInsensitive = 0, $enableTags = 0, $enableTagParams = '' ) {
				
		if ( is_array($search) ) {
			for ( $i = 0; $i < count($search); $i++ ) {
				$s = $search[$i];
				$r = $replace;
				if ( is_array($replace) ) {
					$r = ( count($replace) > $i ) ? $replace[$i] : $replace[0];
				}
				$string = $this->replacer($s, $r, $string, $isRegex, $caseInsensitive, $enableTags, $enableTagParams );
			}
		} else {			
			if ( $enableTags != 1 ) {
				$string = $this->replacerProtect($search, $string, $caseInsensitive, $enableTags, $enableTagParams);
			}
				
			if ( $isRegex ) {
				$regex_mods = 's'; // . (dot) also matches newlines
				if ( $caseInsensitive ) $regex_mods .= 'i'; // case-insensitive pattern matching		
				$string = preg_replace('#'.$search.'#'.$regex_mods, $replace, $string);
			} else {
				if ( $caseInsensitive ) {
					$string = str_replace($search, $replace, $string);
				} else {
					$string = str_replace($search, $replace, $string);
				}
			}
		}
		
		return $string;
	}
	
	function replacerProtect( $search, $string, $caseInsensitive = 0, $enableTags = 0, $enableTagParams = ''  ) {
		// convert list to a array with trimmed items
		$enableTagParams = array_map('trim', explode(',',$enableTagParams));
		
		$regex_mods = 's'; // . (dot) also matches newlines
		if ( $caseInsensitive ) $regex_mods .= 'i'; // case-insensitive pattern matching
		$search_regex = '(<[^>]*? ([^\s]+)\s*=[^=>]*)('.$search.')(?=.*?>)';
		if ( preg_match_all('#'.$search_regex.'#'.$regex_mods, $string, $matches, PREG_SET_ORDER) > 0 ) {						
			foreach ( $matches as $match ) {
				$tag_before		= $match[1];
				$tag_param		= $match[2];
				$found_match	= $match[3];
				if ( $enableTags == 0 || !in_array($tag_param, $enableTagParams) ) {
					$protected_match = $this->RR_params['protector_string'].'_START'.convert_uuencode($found_match).$this->RR_params['protector_string'].'_END';
					$string = str_replace($match[0], $tag_before.$protected_match, $string);
				}
			}
		}
		return $string;
	}

	function replacerClean( $string ) {
		$regex_mods = 's'; // . (dot) also matches newlines
		$protected_match =  $this->RR_params['protector_string'].'_START(.*?)'.$this->RR_params['protector_string'].'_END';
		if ( preg_match_all('#'.$protected_match.'#'.$regex_mods, $string, $matches, PREG_SET_ORDER) > 0 ) {						
			foreach ( $matches as $match ) {
				$string = str_replace($match[0], convert_uudecode($match[1]), $string);
			}
		}
		return $string;
	}
	
	function getOffState($name = '') {
		// Set and find cookies to turn search and replaces off
		global $mainframe;
		
		if ( !$name ) return 0;
		
		$offState = JRequest::getCmd($name);
		if ( ($offState === '1') ) {
			$state = $mainframe->setUserState($name, '1');
		} elseif ( ($offState === '0') ) {
			$state = $mainframe->setUserState($name, '0');
		} else {
			$state = $mainframe->getUserState($name);
		}

		return $offState;
		
	}
}
