<?php
////////////////////////////////////////////////////////////////////
// FILE:         regexarea.php
//------------------------------------------------------------------
// NAME:         Element: RegExArea
// DESCRIPTION:  Element to displays a textarea suitable for regex's
// VERSION:      1.0.0
// CREATED:      May 2008
// MODIFIED:     May 2008
//------------------------------------------------------------------
// AUTHOR:       NoNumber! (Peter van Westen)
// E-MAIL:       peter@nonumber.nl
// WEBSITE:      http://www.nonumber.nl
//------------------------------------------------------------------
// COPYRIGHT:    (C) 2008-2010 - NoNumber! - All Rights Reserved
// LICENSE:      http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
////////////////////////////////////////////////////////////////////

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

class JElementRegExArea extends JElement {
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'RegExArea';

	function fetchElement($name, $value, &$node, $control_name)
	{
		// restore slashed characters
		$value = str_replace("\n",'\n',$value);
		$value = str_replace("\r",'\r',$value);
		$value = str_replace('\|','|',$value);
		$rows = $node->attributes('rows');
		$cols = $node->attributes('cols');
		$class = ( $node->attributes('class') ? 'class="'.$node->attributes('class').'"' : 'class="text_area"' );
		return '<textarea name="'.$control_name.'['.$name.']" cols="'.$cols.'" rows="'.$rows.'" '.$class.' id="'.$control_name.$name.'" >'.$value.'</textarea>';
	}
}