<?php
////////////////////////////////////////////////////////////////////
// FILE:         adminpage_1.inc.php
//------------------------------------------------------------------
// PACKAGE:      adminpage
// NAME:         Admin page (includes)
// DESCRIPTION:  Used to create HTML pages for admin pages
// VERSION:      1.0.0
// CREATED:      April 2008
// MODIFIED:     April 2008
//------------------------------------------------------------------
// AUTHOR:       NoNumber! (Peter van Westen)
// E-MAIL:       peter@nonumber.nl
// WEBSITE:      http://www.nonumber.nl
//------------------------------------------------------------------
// COPYRIGHT:    (C) 2008-2010 - NoNumber! - All Rights Reserved
// LICENSE:      http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
////////////////////////////////////////////////////////////////////

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

////////////////////////////////////////////////////////////////////
// SET ROOT PATHS CORRECTLY
////////////////////////////////////////////////////////////////////

	$path_base	= str_replace('\\','/',$_SERVER['DOCUMENT_ROOT']);
	$url_root	= str_replace($path_base,'',str_replace('\\','/',dirname(__FILE__)));
	$file_root = explode('/',$url_root);
	foreach ( $file_root as $folder ) {
		if ( !in_array( $folder, array('administrator','components','modules','plugins','templates') ) ) {
			array_shift ($file_root);
		} else {
			break;
		}
	}
	$file_root = implode('/',$file_root);
	$admin_root = 'administrator';
	
	$_SERVER['PHP_SELF'] = str_replace( $file_root, $admin_root, $_SERVER['PHP_SELF'] );
	$_SERVER['SCRIPT_NAME'] = str_replace( $file_root, $admin_root, $_SERVER['SCRIPT_NAME'] );
	
	define( 'DS', DIRECTORY_SEPARATOR );
	define('JPATH_BASE', dirname( str_replace( str_replace( '/', DS, $file_root ), str_replace( '/', DS, $admin_root), __FILE__ ) ) );

////////////////////////////////////////////////////////////////////
// SET TEMPLATE AND OPTION
////////////////////////////////////////////////////////////////////

	$_REQUEST['tmpl'] = 'component';
	$_REQUEST['option'] = 'com_admin';
	// this option returns an empty html body if no task is set

////////////////////////////////////////////////////////////////////
// DO ALL THE ADMIN STUFF (copied from the admin index.php)
////////////////////////////////////////////////////////////////////

	require_once( JPATH_BASE .DS.'includes'.DS.'defines.php' );
	require_once( JPATH_BASE .DS.'includes'.DS.'framework.php' );
	require_once( JPATH_BASE .DS.'includes'.DS.'helper.php' );
	require_once( JPATH_BASE .DS.'includes'.DS.'toolbar.php' );

	/* CREATE THE APPLICATION */
	$mainframe =& JFactory::getApplication('administrator');
	/* INITIALISE THE APPLICATION */
	$mainframe->initialise(array(
		'language' => $mainframe->getUserState( "application.lang", 'lang' )
	));
	/* ROUTE THE APPLICATION */
	$mainframe->route();
	/* DISPATCH THE APPLICATION */
	$option = JAdministratorHelper::findOption();
	$mainframe->dispatch($option);
	/* RENDER THE APPLICATION */
	$mainframe->render();

////////////////////////////////////////////////////////////////////
// INCLUDE LANGUAGE FILES
////////////////////////////////////////////////////////////////////
	$lang =& JFactory::getLanguage();
	
	/* template language file */
	$lang->load( 'tpl_'.$mainframe->getTemplate() );
	
	/* current plugin language file */
	$path_base	= str_replace('\\','/',$_SERVER['DOCUMENT_ROOT']);
	$url_root	= str_replace($path_base,'',str_replace('\\','/',dirname(__FILE__)));
	$file_root = explode('/',$url_root);
	foreach ( $file_root as $folder ) {
		if ( !in_array( $folder, array('components','modules','plugins') ) ) {
			array_shift ($file_root);
		} else {
			break;
		}
	}
	if ( count($file_root) > 1 ) {
		switch ( $file_root[0] ) {
			case 'plugins':
				$file_root[0] = 'plg';
				$lang_file = 'plg_'.trim( $file_root[1] ).'_'.trim( $file_root[2] );
				break;
			default:
				$lang_file = $file_root[1];
				break;
		}
		$lang->load( trim( $lang_file ), JPATH_ADMINISTRATOR );
	}

////////////////////////////////////////////////////////////////////
?>